<?php
/**
 * @package ClassifiedListing/Templates
 * @version 1.5.4
 */

if ( ! class_exists( 'RtclPro' ) ) {
	return;
}

use Rtcl\Helpers\Functions;
use RtclPro\Helpers\Fns;
use Rtcl\Controllers\Hooks\TemplateHooks;
use RtclPro\Controllers\Hooks\TemplateHooks as ProTemplateHooks;
use radiustheme\Classima\Listing_Functions;
use radiustheme\Classima\RDTheme;
use radiustheme\Classima\Helper;

defined( 'ABSPATH' ) || exit;

$layout_class = 'col-xl-9 col-lg-8 col-sm-12 col-12';

$rtcl_query = rtcl()->wp_query();

$post_num   = Listing_Functions::listing_post_num( $rtcl_query );
$count_text = Listing_Functions::listing_count_text( $post_num );

$rtcl_top_query = Fns::top_listings_query();

if ( ! empty( $rtcl_top_query ) && Fns::is_enable_top_listings() ) {
	Listing_Functions::set_top_query_globally( $rtcl_top_query );
}

$rtcl_query = rtcl()->wp_query();

$general_settings = Functions::get_option( 'rtcl_general_settings' );

if ( isset( $_GET['view'] ) && in_array( $_GET['view'], [ 'grid', 'list' ], true ) ) {
	$view = esc_attr( $_GET['view'] );
} else {
	$view = Functions::get_option_item( 'rtcl_general_settings', 'default_view', 'list' );
}

$map = false;
?>
<?php get_header(); ?>
    <div id="primary" class="content-area classima-listing-archive rtcl">
        <div class="container">
			<?php do_action( 'classima_header_top' ); ?>
			<?php
			$listing_page_id = Functions::get_page_id( 'listings' );
			if ( post_password_required( $listing_page_id ) ) {
				echo get_the_password_form( $listing_page_id );
			} else { ?>
                <div class="row">

					<?php if ( RDTheme::$layout == 'left-sidebar' ): ?>
                        <div class="col-xl-3 col-lg-4 col-sm-12 col-12"><?php Helper::get_custom_listing_template( 'sidebar-archive' ); ?></div>
					<?php endif; ?>

                    <div class="<?php echo esc_attr( $layout_class ); ?>">

						<?php do_action( 'rtcl_archive_description' ); ?>

                        <div class="listing-archive-top rtcl-listings-actions">
                            <h2 class="rtin-title rtcl-result-count"><?php echo esc_html( $count_text ); ?></h2>
                            <div class="listing-sorting">
								<?php TemplateHooks::catalog_ordering(); ?>
								<?php ProTemplateHooks::view_switcher(); ?>
                            </div>
                        </div>

						<?php do_action( 'classima_listing_before_items' ); ?>

						<?php $wrap_class = $post_num ? [] : [ 'no-listing-found' ]; ?>

                        <div <?php Functions::listing_loop_start_class( $wrap_class ) ?>>

							<?php if ( $post_num ): ?>
								<?php Listing_Functions::listing_query( $view, $rtcl_query, $rtcl_top_query, $map ); ?>
							<?php else: ?>
								<?php Helper::get_custom_listing_template( 'noresults' ); ?>
							<?php endif; ?>

                        </div>

						<?php do_action( 'classima_listing_after_items' ); ?>

						<?php Helper::get_template_part( 'template-parts/pagination' ); ?>

                    </div>

					<?php if ( RDTheme::$layout == 'right-sidebar' ): ?>
                        <div class="col-xl-3 col-lg-4 col-sm-12 col-12"><?php Helper::get_custom_listing_template( 'sidebar-archive' ); ?></div>
					<?php endif; ?>

                </div>
			<?php } ?>
        </div>
    </div>
<?php get_footer(); ?>